# -*- coding: utf-8 -*-
"""
Created on Tue Jul 27 19:06:39 2021

@author: thomas
Maschenströme (Wechselstrom)

"""

import numpy as np
import numpy.linalg
U1 = 230
U2 = -230
U3 = 230
U4 = -230
Z1 = 1 + 2j
Z2 = 2 - 4j
Z3 = 3 + 4j
Z4 = 2 + 5j
Z5 = 1 + 5j
Z6 = 2 + 5j
Z7 = 4 - 5j
Z8 = 1 + 5j

Z = np.array([[Z1 + Z2 + Z4, -Z2, -Z4, 0],
              [-Z2, Z2 + Z3 + Z5, 0, -Z5],
              [-Z4, 0, Z4 + Z6 + Z7, -Z7],
              [0, -Z5, -Z7, Z5 + Z7 + Z8]])
U = np.array([U1, -U2, U3, -U4])
I = np.linalg.solve(Z, U)
I = np.round(I, decimals = 2)

print("Maschenstrom 1:",I[0],"A")
print("Maschenstrom 2:",I[1],"A")
print("Maschenstrom 3:",I[2],"A")
print("Maschenstrom 4:",I[3],"A")
